/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDListItem;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.border.Border;

public class QDListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private ImageIcon m_icon;
    private static Border m_normalBorder = null;
    private static Border m_pressedBorder = null;

    public QDListRenderer() {
        this.m_icon = null;
        this.initLook();
    }

    public QDListRenderer(ImageIcon imageIcon) {
        this.m_icon = imageIcon;
        this.initLook();
    }

    private void initLook() {
        this.setFont(QDStdUI.getActionFont());
        this.setFocusable(true);
        if (m_normalBorder == null) {
            Border border = BorderFactory.createLineBorder(QDStdUI.getActionBackground(), 1);
            Border border2 = BorderFactory.createEmptyBorder(3, 5, 3, 5);
            m_normalBorder = BorderFactory.createEmptyBorder(4, 6, 4, 6);
            m_pressedBorder = BorderFactory.createCompoundBorder(border, border2);
        }
    }

    public void setIcon(ImageIcon imageIcon) {
        this.m_icon = imageIcon;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Object object2;
        this.setIcon(this.m_icon);
        this.setText(object.toString());
        boolean bl3 = false;
        if (object instanceof QDListItem) {
            object2 = (QDListItem)object;
            bl3 = ((QDListItem)object2).isMarked();
            if (((QDListItem)object2).getIcon() != null) {
                this.setIcon(((QDListItem)object2).getIcon());
            }
        }
        this.setComponentOrientation(jList.getComponentOrientation());
        if (bl) {
            if (bl3) {
                this.setBackground(Color.black);
                this.setForeground(QDStdUI.getSelectedColor());
            } else {
                this.setBackground(QDStdUI.getSelectedColor());
                this.setForeground(Color.black);
            }
        } else {
            this.setBackground(QDStdUI.getBackground());
            if (bl3) {
                this.setForeground(QDStdUI.getActionForeground());
            } else {
                this.setForeground(QDStdUI.getForeground());
            }
        }
        this.setEnabled(jList.isEnabled());
        this.setFont(QDStdUI.getActionFont());
        object2 = null;
        object2 = bl2 ? (bl ? m_pressedBorder : m_normalBorder) : m_normalBorder;
        this.setBorder((Border)object2);
        return this;
    }
}

